* Data can be downloaded from the GLES: https://www.gesis.org/wahlen/gles
* set wd
cd " "
use ZA6838_allwaves_sA_v4-0-0.dta, clear

gen id=lfdn

*One variable with a string indicating which waves respondents participated in - separate into binary variables for each wave
split p_participation,parse("-")

*Waves "a1" and "a2" are "Profile Waves" - the first waves which a part of the sample was recruited into - but they also responded to questions in those waves and they were fielded in particular periods here, so I separate them here as separate waves and re-number the waves accordingly (later in the code)
*Only respondents who participated in a1 or a2 are valid on the 14th string variable (because others only had 13 digits) and we've recoded them into new variables, so drop that one
gen p_participationa1="0"
replace p_participationa1="1" if p_participation5=="a1"
gen p_participationa2="0"
replace p_participationa2="1" if p_participation14=="a2"

*The p_participation variable is coded oddly for this, the "a1" is only indicated for those who took part in it and not others, which means the string has more digits for those who participated in it - so we need to re-designate participation values for successive waves for those who participated in it (move it forward by one)
replace p_participation5=p_participation6 if p_participationa1=="1"
replace p_participation6=p_participation7 if p_participationa1=="1"
replace p_participation7=p_participation8 if p_participationa1=="1"
replace p_participation8=p_participation9 if p_participationa1=="1"
replace p_participation9=p_participation10 if p_participationa1=="1"
replace p_participation10=p_participation11 if p_participationa1=="1"
replace p_participation11=p_participation12 if p_participationa1=="1"
replace p_participation12=p_participation13 if p_participationa1=="1"
replace p_participation13=p_participation14 if p_participationa1=="1"

gen participation1=real(p_participation1)
gen participation2=real(p_participation2)
gen participation3=real(p_participation3)
gen participation4=real(p_participation4)
gen participation5=real(p_participation5)
gen participation6=real(p_participation6)
gen participation7=real(p_participation7)
gen participation8=real(p_participation8)
gen participation9=real(p_participation9)
gen participation10=real(p_participation10)
gen participation11=real(p_participation11)
gen participation12=real(p_participation12)
gen participation13=real(p_participation13)
gen participationa1=real(p_participationa1)
gen participationa2=real(p_participationa2)

drop p_participation1 p_participation2 p_participation3 p_participation4 p_participation5 p_participation6 p_participation7 p_participation8 p_participation9 p_participation10 p_participation11 p_participation12 p_participation13 p_participation14

save "GLES_AllWaves.dta", replace

**Create sub-dataset for these variables in each wave
foreach x in 1 2 3 4 5 6 7 8 9 10 11 12 13 a1 a2 {
use "GLES_AllWaves.dta", clear

gen str wave_str="`x'"

cap gen gender=kpx_2280
cap gen born=kpx_2290s

gen born_bundes=kpx_3920
cap _crcslbl born_bundes kpx_3920
cap la val born_bundes kpx_3920

gen born_other=kpx_3930
cap _crcslbl born_other kpx_3930
cap la val born_other kpx_3930

gen bundesland=kp1_2601
cap replace bundesland=kp`x'_2601
cap _crcslbl bundesland kp1_2601
cap la val bundesland kp1_2601

cap gen edu_full=kp1_2320
cap replace edu_full=kp`x'_2320
cap replace edu_full=kp`x'_2320

cap _crcslbl edu_full kp`x'_2320
cap la val edu_full kp`x'_2320
cap recode edu_full (-95 -93 9=.) (1 2=1) (2 3=2) (5=3),gen(edu)

cap gen hincome=kp1_2591
cap _crcslbl hincome kp1_2591
cap la val hincome kp1_2591

cap gen workstatus=kp1_2340
cap replace workstatus=kp`x'_2340
cap _crcslbl workstatus kp1_2340
cap la val workstatus kp1_2340

cap gen trust_parl=kp`x'_160a
cap gen trust_parl=. 
cap _crcslbl trust_parl kp`x'_160a
cap la val trust_parl kp`x'_160a

cap gen trust_leg=kp`x'_160b
cap gen trust_leg=. 
cap _crcslbl trust_leg kp`x'_160b
cap la val trust_leg kp`x'_160b

cap gen trust_army=kp`x'_160j
cap gen trust_army=. 
cap _crcslbl trust_army kp`x'_160j
cap la val trust_army kp`x'_160j

cap gen trust_unions=kp`x'_160k
cap gen trust_unions=. 
cap _crcslbl trust_unions kp`x'_160k
cap la val trust_unions kp`x'_160k

cap gen trust_banks=kp`x'_160o
cap gen trust_banks=. 
cap _crcslbl trust_banks kp`x'_160o
cap la val trust_banks kp`x'_160o

cap gen trust_media=kp`x'_160p
cap gen trust_media=. 
cap _crcslbl trust_media kp`x'_160p
cap la val trust_media kp`x'_160p

cap gen trust_police=kp`x'_160q
cap gen trust_police=. 
cap _crcslbl trust_police kp`x'_160q
cap la val trust_police kp`x'_160q

cap gen demsat=kp`x'_020
cap gen demsat=. 
cap _crcslbl demsat kp`x'_020
cap la val demsat kp`x'_020

cap gen polint=kp`x'_010
cap gen polint=. 
cap _crcslbl polint kp`x'_010
cap la val polint kp`x'_010

cap gen leftright=kp`x'_1500
cap gen leftright=. 
cap _crcslbl leftright kp`x'_1500
cap la val leftright kp`x'_1500

cap gen pidA=kp`x'_2090a
cap gen pidA=. 
cap _crcslbl pidA kp`x'_2090a
cap la val pidA kp`x'_2090a

cap gen pidB=kp`x'_2090b
cap gen pidB=. 
cap _crcslbl pidB kp`x'_2090b
cap la val pidB kp`x'_2090b

cap gen datetime=kp`x'_datetime
cap gen datetime=. 
cap _crcslbl datetime kp`x'_datetime
cap la val datetime kp`x'_datetime

keep if participation`x'==1

keep id wave_str datetime sample n_participation p_participation participation1 participation2 participation3 participation4 participation5 participation6 participation7 participation8 participation9 participation10 participation11 participation12 participation13 participationa1 participationa2 ostwest born_bundes born_other bundesland gender born edu_full edu hincome workstatus trust_parl trust_leg trust_army trust_unions trust_banks trust_media trust_police demsat polint leftright pidA pidB 

order id wave_str datetime sample n_participation p_participation participation1 participation2 participation3 participation4 participation5 participation6 participation7 participation8 participation9 participation10 participation11 participation12 participation13 participationa1 participationa2 ostwest born_bundes born_other bundesland gender born edu_full edu hincome workstatus trust_parl trust_leg trust_army trust_unions trust_banks trust_media trust_police demsat polint leftright pidA pidB

save GLES_panel_W`x'.dta, replace
}

use GLES_panel_W2.dta, clear
foreach x in 1 3 4 5 6 7 8 9 10 11 12 13 a1 a2 {
append using GLES_panel_W`x'.dta
}

drop if datetime=="-95"
split datetime
rename datetime1 date
rename datetime2 time

split date,parse(-)
gen year=real(date1)
gen date_month=real(date2)
gen date_day=real(date3)

gen date_2=date(date,"YMD")

**Timing of waves:
*Wave 1 - Oct-Nov 2016
*Wave 2 - Feb-March 2017
*Wave 3 - May 2017
*Wave 4 - July 2017
*Wave a1 (Profile Wave) - July-August 2017
*Wave 5 - August 2017
*Wave 6 - Sept1 2017
*Wave 7 - Sept2 2017
*Wave 8 - Sept-Oct 2017
*Wave 9 - March 2018
*Wave 10 - Nov 2018
*Wave 11 - May-June 2019
*Wave 12 - Nov 2019
*Wave 13 - April-May 2020
*Wave a2 (Profile Wave) - Sept-Nov 2020

gen wave=.
replace wave=1 if wave_str=="1"
replace wave=2 if wave_str=="2"
replace wave=3 if wave_str=="3"
replace wave=4 if wave_str=="4"
replace wave=5 if wave_str=="a1"
replace wave=6 if wave_str=="5"
replace wave=7 if wave_str=="6"
replace wave=8 if wave_str=="7"
replace wave=9 if wave_str=="8"
replace wave=10 if wave_str=="9"
replace wave=11 if wave_str=="10"
replace wave=12 if wave_str=="11"
replace wave=13 if wave_str=="12"
replace wave=14 if wave_str=="13"
replace wave=15 if wave_str=="a2"

la de wave 1 "Oct-Nov '16'" 2 "Feb-March '17'" 3 "May '17'" 4 "July '17'" 5 "July/Aug '17'" 6 "Aug '17'" 7 "Sept1 '17'" 8 "Sept2 '17'" 9 "Sept-Oct '17'" 10 "March '18'" 11 "Nov '18'" 12 "May-June '19'" 13 "Nov '19'" 14 "April-May '20'" 15 "Sept-Nov '20'"
la val wave wave

gen wave1=participation1
gen wave2=participation2
gen wave3=participation3
gen wave4=participation4
gen wave5=participationa1
gen wave6=participation5
gen wave7=participation6
gen wave8=participation7
gen wave9=participation8
gen wave10=participation9
gen wave11=participation10
gen wave12=participation11
gen wave13=participation12
gen wave14=participation13
gen wave15=participationa2

la var wave1 "Participated in Wave 1"
la var wave2 "Participated in Wave 2"
la var wave3 "Participated in Wave 3"
la var wave4 "Participated in Wave 4"
la var wave5 "Participated in Wave 5 (a1)"
la var wave6 "Participated in Wave 6"
la var wave7 "Participated in Wave 7"
la var wave8 "Participated in Wave 8"
la var wave9 "Participated in Wave 9"
la var wave10 "Participated in Wave 10"
la var wave11 "Participated in Wave 11"
la var wave12 "Participated in Wave 12"
la var wave13 "Participated in Wave 13"
la var wave14 "Participated in Wave 14"
la var wave15 "Participated in Wave 15 (a2)"

egen wave_no=rowtotal(wave1 wave2 wave3 wave4 wave5 wave6 wave7 wave8 wave9 wave10 wave11 wave12 wave13 wave14 wave14 wave15)
la var wave_no "Number of waves participated in"

gen month=1
replace month=5 if wave==2
replace month=8 if wave==3
replace month=10 if wave==4
replace month=10.5 if wave==5
replace month=11 if wave==6
replace month=12 if wave==7
replace month=12.5 if wave==8
replace month=13 if wave==9
replace month=18 if wave==10
replace month=26 if wave==11
replace month=32 if wave==12
replace month=38 if wave==13
replace month=43 if wave==14
replace month=48 if wave==15

la var month "Number of months since first wave"

*Age and cohorts
*Year of birth is only coded back to 1955, grouping older respondents together as "1955 and before"...
rename born born_str
gen born_str2=born_str
replace born_str2="1955" if born_str=="1955 und frueher"
encode born_str2, gen(born)

gen age=year-born
recode age (16/24=1) (25/30=2) (31/50=3) (51/max=4),gen(agegroups)
la de agegroups 1 "18-24 years" 2 "25-30 years" 3 "31-50 years" 4 "51 years+"
la val agegroups agegroups

rename demsat demsat_de
la var demsat_de "Satisfaction with democracy"
la de demsat_de -99 "Keine Angabe"	-95 "Nicht teilgenommen" -93 "Interview abgebrochen" 1 "Suhr zufrieden" 2 "Zufrieden" 3 "Teils/teils" 4 "Unzufrieden" 5 "Sehr unzufrieden"
la val demsat_de demsat_de

recode demsat_de (-99 -95 -93=.) (1=5) (2=4) (3=3) (4=2) (5=1),gen(demsat5)
la de demsat5 1 "Very dissatisfied" 2 "Dissatisfied" 3 "Neither satisfied nor dissatisfied" 4 "Satisfied" 5 "Very satisfied"
la val demsat5 demsat5
recode demsat5 (1 2 3=0) (4 5=1),gen(demsat1)

rename trust_parl trust_parl_de
recode trust_parl_de (-99 -95 -93=.),gen(trust_parl)
rename trust_leg trust_leg_de
recode trust_leg_de (-99 -95 -93=.),gen(trust_leg)
rename trust_army trust_army_de
recode trust_army_de (-99 -95 -93=.),gen(trust_army)
rename trust_unions trust_unions_de
recode trust_unions_de (-99 -95 -93=.),gen(trust_unions)
rename trust_banks trust_banks_de
recode trust_banks_de (-99 -95 -93=.),gen(trust_banks)
rename trust_media trust_media_de
recode trust_media_de (-99 -95 -93=.),gen(trust_media)
rename trust_police trust_police_de
recode trust_police_de (-99 -95 -93=.),gen(trust_police)

save "GLES_panel.dta", replace